﻿#pragma once
#include "Unit.h"
#include "StgSystem.h"
#include "Scene.h"
#include "Objects.h"

namespace SDX
{
	class Wepon;

class Player : public Unit
{
protected:
	int weponCount = 0;

	virtual void Update()
	{
		if (invTime > 0)
		{
			if (invTime % 2)
			{
				SetColor({ 255, 255, 255, 255 });
			}
			else
			{
				SetColor({ 255, 255, 255, 0 });
			}
			--invTime;
		}

		++timer;
		AnimeUpdate();
		カーソル移動();

		if (hyperGage < 100 && hyperTime <= 0) hyperGage += 0.1;

		if (Input::pad.Button2.hold && hyperGage >= 100)
		{
			hyperTime = 200;
			hyperGage = 0;
		}
		--hyperTime;

		StgSystem::maxShield = (int)hpMax;
		StgSystem::shield = (int)hp;
		StgSystem::charge = (int)hyperGage;

		Act();
		カメラ制御();
	}

	void AddWepon( Object *wepon )
	{
		Scene::Add(wepon);
		++weponCount;
	}

public:
	int hyperTime = 0;
	int changeTime = 0;
	double hyperGage = 0;
	double speed;

	int GetWeponCount()
	{
		return weponCount;
	}

	Player( Shape *shape , Sprite *前進絵 , Sprite *横絵 , double hpMax , double power ,double speed = 10) :
		Unit(shape, 前進絵, hpMax, power, Belong::Ally),
		speed(speed)
	{
		Model::Add(横絵);
		StgSystem::maxShield = (int)hpMax;
		StgSystem::shield = (int)hpMax;
		StgSystem::charge = 0;
		isOutCheck = false;
	}

	void カーソル移動()
	{
		double vx = Input::pad.Right.hold - Input::pad.Left.hold;
		double vy = Input::pad.Down.hold  - Input::pad.Up.hold;

		if (vx != 0 && vy != 0)
		{
			vx *= 0.7;
			vy *= 0.7;
		}

		Move(vx * speed, vy * speed);

		if (vx != 0)
		{
			sprites[0]->isVisible = false;
			sprites[1]->isVisible = true;
			sprites[1]->isTurn = (vx < 0);
			changeTime = 5;
		}

		changeTime--;

		if (changeTime == 0)
		{
			sprites[0]->isVisible = true;
			sprites[1]->isVisible = false;
		}

		const double left	= Scene::Now()->moveArea.GetLeft();
		const double top	= Scene::Now()->moveArea.GetTop();
		const double right	= Scene::Now()->moveArea.GetRight();
		const double bottom = Scene::Now()->moveArea.GetBottom();

		if ( GetX() < left	 ) SetPos(left	, GetY() );
		if ( GetY() < top	 ) SetPos(GetX(), top	 );
		if ( GetY() > bottom ) SetPos(GetX(), bottom );
		if ( GetX() > right	 ) SetPos(right	, GetY() );
	}

	void Remove()
	{
		Scene::Add(new エフェクト(&MEffect::爆発[12], GetX(), GetY()));
		StgSystem::shield = 0;
		StgSystem::charge = 0;
		isRemove = true;
	}

	void React()
	{
		this->invTime = 30;
	}

	void カメラ制御()
	{
		const int nowX = (int)GetX();

		//600

		//32 * 30 = 960;
		//800 - 300 = 500 が表示
		//0～600

		//

		// 250 - 
		// 350
		//0 - 250
		//600 - 400

		if (Camera::Now()->GetZoom() >= 1)
		{
			Camera::Now()->SetForcus(250 + nowX / 6, 300);
		}
		else
		{
			Camera::Now()->SetForcus(300, 300);
		}
	}
};
}